﻿package  {
  
  public class MathHelper {
    
    // Constants:
    // Public Properties:
    // Private Properties:
  
    // Initialization:
    public function MathHelper() { }
  
    // Public Methods:
    // Protected Methods:
    
    public static function smoothDamp(current : Number, target : Number, velocity : NumericContainer, 
                                      smoothTime : Number, deltaTime : Number) : Number {
      var x0 : Number = current - target;
      var xp0 : Number = velocity.val;
    
      // apply the damping function
      var r : Number = (x0 + (deltaTime * (xp0 + (smoothTime * x0)))) * 
               Math.exp(-smoothTime * deltaTime) + target;
    
      velocity.val = (r - current) / deltaTime;
    
      //return result;
      return r;
    }
  
    public static function clamp(current : Number, min : Number, max : Number) : Number {
      if(current < min)
        return min;
    
      if(current > max)
        return max;
      
      return current;
    }
  }
  
}